/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.errlog;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import cz.insophy.inplan.util.errlog.ErrorLogItem;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ErrorLog
implements Iterable<ErrorLogItem> {
    private final List<ErrorLogItem> errors = Lists.newArrayList();

    @Nonnull
    private Object fix(@Nullable Object o) {
        if (o == null) {
            return "<null>";
        }
        return o;
    }

    public void add(int priority, @Nonnull String msgKey) {
        this.add(priority, msgKey, ImmutableMap.of());
    }

    public void add(int priority, @Nonnull String msgKey, @Nonnull String key, @Nullable Object val) {
        this.add(priority, msgKey, ImmutableMap.of(key, this.fix(val)));
    }

    public void add(int priority, @Nonnull String msgKey, @Nonnull String key, @Nullable Object val, @Nonnull String key2, @Nullable Object val2) {
        this.add(priority, msgKey, ImmutableMap.of(key, this.fix(val), key2, this.fix(val2)));
    }

    public void add(int priority, @Nonnull String msgKey, @Nonnull String key, @Nullable Object val, @Nonnull String key2, @Nullable Object val2, @Nonnull String key3, @Nullable Object val3) {
        this.add(priority, msgKey, ImmutableMap.of(key, this.fix(val), key2, this.fix(val2), key3, this.fix(val3)));
    }

    public void add(int priority, @Nonnull String msgKey, @Nonnull String key, @Nullable Object val, @Nonnull String key2, @Nullable Object val2, @Nonnull String key3, @Nullable Object val3, @Nonnull String key4, @Nullable Object val4) {
        this.add(priority, msgKey, ImmutableMap.of(key, this.fix(val), key2, this.fix(val2), key3, this.fix(val3), key4, this.fix(val4)));
    }

    public void add(int priority, @Nonnull String msgKey, @Nonnull String key, @Nullable Object val, @Nonnull String key2, @Nullable Object val2, @Nonnull String key3, @Nullable Object val3, @Nonnull String key4, @Nullable Object val4, @Nonnull String key5, @Nullable Object val5) {
        this.add(priority, msgKey, ImmutableMap.of(key, this.fix(val), key2, this.fix(val2), key3, this.fix(val3), key4, this.fix(val4), key5, this.fix(val5)));
    }

    private void add(int priority, String msgKey, ImmutableMap<String, Object> data) {
        this.errors.add(new ErrorLogItem(priority, msgKey, data));
    }

    public List<ErrorLogItem> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public void dumpTo(PrintWriter writer) throws IOException {
        this.errors.forEach(writer::println);
        writer.flush();
    }

    public void dumpTo(OutputStream out) throws IOException {
        this.dumpTo(new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    @Override
    public Iterator<ErrorLogItem> iterator() {
        return Iterators.unmodifiableIterator(this.errors.iterator());
    }
}

